"""
Curves in this class are heavily inspired from
- https://neuromancer.sk/std/search/
"""

# project dependencies
from lightecc.interfaces.form import KoblitzInterface
from lightecc.commons.logger import Logger

logger = Logger(module="lightecc/curves/koblitz.py")

DEFAULT_CURVE = "k163"


# pylint: disable=too-few-public-methods
class K409(KoblitzInterface):
    m = 409
    coefficients = [409, 87, 0]
    a = 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
    b = 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001
    G = (
        0x060F05F658F49C1AD3AB1890F7184210EFD0987E307C84C27ACCFB8F9F67CC2C460189EB5AAAA62EE222EB1B35540CFE9023746,
        0x1E369050B7C4E42ACBA1DACBF04299C3460782F918EA427E6325165E9EA10E3DA5F6C42E9C55215AA9CA27A5863EC48D8E0286B,
    )
    n = 0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE5F83B2D4EA20400EC4557D5ED3E3E7CA5B4B5C83B8E01E5FCF


class K163(KoblitzInterface):
    m = 163
    coefficients = [163, 7, 6, 3, 0]
    a = 0x000000000000000000000000000000000000000001
    b = 0x000000000000000000000000000000000000000001
    G = (
        0x02FE13C0537BBC11ACAA07D793DE4E6D5E5C94EEE8,
        0x0289070FB05D38FF58321F2E800536D538CCDAA3D9,
    )
    n = 0x04000000000000000000020108A2E0CC0D99F8A5EF


class K233(KoblitzInterface):
    m = 233
    coefficients = [233, 74, 0]
    a = 0x000000000000000000000000000000000000000000000000000000000000
    b = 0x000000000000000000000000000000000000000000000000000000000001
    G = (
        0x017232BA853A7E731AF129F22FF4149563A419C26BF50A4C9D6EEFAD6126,
        0x01DB537DECE819B7F70F555A67C427A8CD9BF18AEB9B56E0C11056FAE6A3,
    )
    n = 0x8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDF


class K283(KoblitzInterface):
    m = 283
    coefficients = [283, 12, 7, 5, 0]
    a = 0x00000000000000000000000000000000000000000000000000000000000000000000000
    b = 0x00000000000000000000000000000000000000000000000000000000000000000000001
    G = (
        0x503213F78CA44883F1A3B8162F188E553CD265F23C1567A16876913B0C2AC2458492836,
        0x1CCDA380F1C9E318D90F95D07E5426FE87E45C0E8184698E45962364E34116177DD2259,
    )
    n = 0x1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE9AE2ED07577265DFF7F94451E061E163C61


class K571(KoblitzInterface):
    m = 571
    coefficients = [571, 10, 5, 2, 0]
    a = 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
    b = 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001
    G = (
        0x26EB7A859923FBC82189631F8103FE4AC9CA2970012D5D46024804801841CA44370958493B205E647DA304DB4CEB08CBBD1BA39494776FB988B47174DCA88C7E2945283A01C8972,
        0x349DC807F4FBF374F4AEADE3BCA95314DD58CEC9F307A54FFC61EFC006D8A2C9D4979C0AC44AEA74FBEBBB9F772AEDCB620B01A7BA7AF1B320430C8591984F601CD4C143EF1C7A3,
    )
    n = 0x20000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001


class B571(KoblitzInterface):
    m = 571
    coefficients = [571, 10, 5, 2, 0]
    a = 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001
    b = 0x2F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A
    G = (
        0x303001D34B856296C16C0D40D3CD7750A93D1D2955FA80AA5F40FC8DB7B2ABDBDE53950F4C0D293CDD711A35B67FB1499AE60038614F1394ABFA3B4C850D927E1E7769C8EEC2D19,
        0x37BF27342DA639B6DCCFFFEB73D69D78C6C27A6009CBBCA1980F8533921E8A684423E43BAB08A576291AF8F461BB2A8B3531D2F0485C19B16E2F1516E23DD3C1A4827AF1B8AC15B,
    )
    n = 0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47


class B409(KoblitzInterface):
    m = 409
    coefficients = [409, 87, 0]
    a = 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001
    b = 0x021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545F
    G = (
        0x15D4860D088DDB3496B0C6064756260441CDE4AF1771D4DB01FFE5B34E59703DC255A868A1180515603AEAB60794E54BB7996A7,
        0x061B1CFAB6BE5F32BBFA78324ED106A7636B9C5A7BD198D0158AA4F5488D08F38514F1FDF4B4F40D2181B3681C364BA0273C706,
    )
    n = 0x10000000000000000000000000000000000000000000000000001E2AAD6A612F33307BE5FA47C3C9E052F838164CD37D9A21173


class B283(KoblitzInterface):
    m = 283
    coefficients = [283, 12, 7, 5, 0]
    a = 0x00000000000000000000000000000000000000000000000000000000000000000000001
    b = 0x27B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5
    G = (
        0x5F939258DB7DD90E1934F8C70B0DFEC2EED25B8557EAC9C80E2E198F8CDBECD86B12053,
        0x3676854FE24141CB98FE6D4B20D02B4516FF702350EDDB0826779C813F0DF45BE8112F4,
    )
    n = 0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307


class B233(KoblitzInterface):
    m = 233
    coefficients = [233, 74, 0]
    a = 0x000000000000000000000000000000000000000000000000000000000001
    b = 0x0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90AD
    G = (
        0x00FAC9DFCBAC8313BB2139F1BB755FEF65BC391F8B36F8F8EB7371FD558B,
        0x01006A08A41903350678E58528BEBF8A0BEFF867A7CA36716F7E01F81052,
    )
    n = 0x1000000000000000000000000000013E974E72F8A6922031D2603CFE0D7


class B163(KoblitzInterface):
    m = 163
    coefficients = [163, 7, 6, 3, 0]
    a = 0x000000000000000000000000000000000000000001
    b = 0x020A601907B8C953CA1481EB10512F78744A3205FD
    G = (
        0x03F0EBA16286A2D57EA0991168D4994637E8343E36,
        0x00D51FBC6C71A0094FA2CDD545B11C5C0C797324F1,
    )
    n = 0x040000000000000000000292FE77E70C12A4234C33


class Ansit163r1(KoblitzInterface):
    m = 163
    coefficients = [163, 7, 6, 3, 0]
    a = 0x07B6882CAAEFA84F9554FF8428BD88E246D2782AE2
    b = 0x0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9
    G = (
        0x0369979697AB43897789566789567F787A7876A654,
        0x00435EDB42EFAFB2989D51FEFCE3C80988F41FF883,
    )
    n = 0x03FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279B


class Ansit193r1(KoblitzInterface):
    m = 193
    coefficients = [193, 15, 0]
    a = 0x0017858FEB7A98975169E171F77B4087DE098AC8A911DF7B01
    b = 0x00FDFB49BFE6C3A89FACADAA7A1E5BBC7CC1C2E5D831478814
    G = (
        0x01F481BC5F0FF84A74AD6CDF6FDEF4BF6179625372D8C0C5E1,
        0x0025E399F2903712CCF3EA9E3A1AD17FB0B3201B6AF7CE1B05,
    )
    n = 0x01000000000000000000000000C7F34A778F443ACC920EBA49


class Ansit193r2(KoblitzInterface):
    m = 193
    coefficients = [193, 15, 0]
    a = 0x0163F35A5137C2CE3EA6ED8667190B0BC43ECD69977702709B
    b = 0x00C9BB9E8927D4D64C377E2AB2856A5B16E3EFB7F61D4316AE
    G = (
        0x00D9B67D192E0367C803F39E1A7E82CA14A651350AAE617E8F,
        0x01CE94335607C304AC29E7DEFBD9CA01F596F927224CDECF6C,
    )
    n = 0x010000000000000000000000015AAB561B005413CCD4EE99D5


class Ansit239k1(KoblitzInterface):
    m = 239
    coefficients = [239, 158, 0]
    a = 0x000000000000000000000000000000000000000000000000000000000000
    b = 0x000000000000000000000000000000000000000000000000000000000001
    G = (
        0x29A0B6A887A983E9730988A68727A8B2D126C44CC2CC7B2A6555193035DC,
        0x76310804F12E549BDB011C103089E73510ACB275FC312A5DC6B76553F0CA,
    )
    n = 0x2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5


class Sect113r1(KoblitzInterface):
    m = 113
    coefficients = [113, 9, 0]
    a = 0x003088250CA6E7C7FE649CE85820F7
    b = 0x00E8BEE4D3E2260744188BE0E9C723
    G = (0x009D73616F35F4AB1407D73562C10F, 0x00A52830277958EE84D1315ED31886)
    n = 0x0100000000000000D9CCEC8A39E56F


class Sect113r2(KoblitzInterface):
    m = 113
    coefficients = [113, 9, 0]
    a = 0x00689918DBEC7E5A0DD6DFC0AA55C7
    b = 0x0095E9A9EC9B297BD4BF36E059184F
    G = (0x01A57A6A7B26CA5EF52FCDB8164797, 0x00B3ADC94ED1FE674C06E695BABA1D)
    n = 0x010000000000000108789B2496AF93


class Sect131r1(KoblitzInterface):
    m = 131
    coefficients = [131, 8, 3, 2, 0]
    a = 0x07A11B09A76B562144418FF3FF8C2570B8
    b = 0x0217C05610884B63B9C6C7291678F9D341
    G = (0x0081BAF91FDF9833C40F9C181343638399, 0x078C6E7EA38C001F73C8134B1B4EF9E150)
    n = 0x0400000000000000023123953A9464B54D


class Sect131r2(KoblitzInterface):
    m = 131
    coefficients = [131, 8, 3, 2, 0]
    a = 0x03E5A88919D7CAFCBF415F07C2176573B2
    b = 0x04B8266A46C55657AC734CE38F018F2192
    G = (0x0356DCD8F2F95031AD652D23951BB366A8, 0x0648F06D867940A5366D9E265DE9EB240F)
    n = 0x0400000000000000016954A233049BA98F


class C2pnb176w1(KoblitzInterface):
    m = 176
    coefficients = [176, 43, 2, 1, 0]
    a = 0xE4E6DB2995065C407D9D39B8D0967B96704BA8E9C90B
    b = 0x5DDA470ABE6414DE8EC133AE28E9BBD7FCEC0AE0FFF2
    G = (
        0x8D16C2866798B600F9F08BB4A8E860F3298CE04A5798,
        0x6FA4539C2DADDDD6BAB5167D61B436E1D92BB16A562C,
    )
    n = 0x010092537397ECA4F6145799D62B0A19CE06FE26AD


class C2pnb163v1(KoblitzInterface):
    m = 163
    coefficients = [163, 8, 2, 1, 0]
    a = 0x072546B5435234A422E0789675F432C89435DE5242
    b = 0x00C9517D06D5240D3CFF38C74B20B6CD4D6F9DD4D9
    G = (
        0x07AF69989546103D79329FCC3D74880F33BBE803CB,
        0x01EC23211B5966ADEA1D3F87F7EA5848AEF0B7CA9F,
    )
    n = 0x0400000000000000000001E60FC8821CC74DAEAFC1


class C2pnb163v2(KoblitzInterface):
    m = 163
    coefficients = [163, 8, 2, 1, 0]
    a = 0x0108B39E77C4B108BED981ED0E890E117C511CF072
    b = 0x0667ACEB38AF4E488C407433FFAE4F1C811638DF20
    G = (
        0x0024266E4EB5106D0A964D92C4860E2671DB9B6CC5,
        0x079F684DDF6684C5CD258B3890021B2386DFD19FC5,
    )
    n = 0x03FFFFFFFFFFFFFFFFFFFDF64DE1151ADBB78F10A7


class C2pnb163v3(KoblitzInterface):
    m = 163
    coefficients = [163, 8, 2, 1, 0]
    a = 0x07A526C63D3E25A256A007699F5447E32AE456B50E
    b = 0x03F7061798EB99E238FD6F1BF95B48FEEB4854252B
    G = (
        0x2F9F87B7C574D0BDECF8A22E6524775F98CDEBDCB,
        0x5B935590C155E17EA48EB3FF3718B893DF59A05D0,
    )
    n = 0x03FFFFFFFFFFFFFFFFFFFE1AEE140F110AFF961309


class C2pnb208w1(KoblitzInterface):
    m = 208
    coefficients = [208, 83, 2, 1, 0]
    a = 0x0
    b = 0xC8619ED45A62E6212E1160349E2BFA844439FAFC2A3FD1638F9E
    G = (
        0x89FDFBE4ABE193DF9559ECF07AC0CE78554E2784EB8C1ED1A57A,
        0x0F55B51A06E78E9AC38A035FF520D8B01781BEB1A6BB08617DE3,
    )
    n = 0x0101BAF95C9723C57B6C21DA2EFF2D5ED588BDD5717E212F9D


class C2tnb191v3(KoblitzInterface):
    m = 191
    coefficients = [191, 9, 0]
    a = 0x6C01074756099122221056911C77D77E77A777E7E7E77FCB
    b = 0x71FE1AF926CF847989EFEF8DB459F66394D90F32AD3F15E8
    G = (
        0x375D4CE24FDE434489DE8746E71786015009E66E38A926DD,
        0x545A39176196575D985999366E6AD34CE0A77CD7127B06BE,
    )
    n = 0x155555555555555555555555610C0B196812BFB6288A3EA3


class C2tnb191v2(KoblitzInterface):
    m = 191
    coefficients = [191, 9, 0]
    a = 0x401028774D7777C7B7666D1366EA432071274F89FF01E718
    b = 0x0620048D28BCBD03B6249C99182B7C8CD19700C362C46A01
    G = (
        0x3809B2B7CC1B28CC5A87926AAD83FD28789E81E2C9E3BF10,
        0x17434386626D14F3DBF01760D9213A3E1CF37AEC437D668A,
    )
    n = 0x20000000000000000000000050508CB89F652824E06B8173


class C2tnb191v1(KoblitzInterface):
    m = 191
    coefficients = [191, 9, 0]
    a = 0x2866537B676752636A68F56554E12640276B649EF7526267
    b = 0x2E45EF571F00786F67B0081B9495A3D95462F5DE0AA185EC
    G = (
        0x36B3DAF8A23206F9C4F299D7B21A9C369137F2C84AE1AA0D,
        0x765BE73433B3F95E332932E70EA245CA2418EA0EF98018FB,
    )
    n = 0x40000000000000000000000004A20E90C39067C893BBB9A5


class C2tnb239v3(KoblitzInterface):
    m = 239
    coefficients = [239, 36, 0]
    a = 0x01238774666A67766D6676F778E676B66999176666E687666D8766C66A9F
    b = 0x6A941977BA9F6A435199ACFC51067ED587F519C5ECB541B8E44111DE1D40
    G = (
        0x70F6E9D04D289C4E89913CE3530BFDE903977D42B146D539BF1BDE4E9C92,
        0x2E5A0EAF6E5E1305B9004DCE5C0ED7FE59A35608F33837C816D80B79F461,
    )
    n = 0x0CCCCCCCCCCCCCCCCCCCCCCCCCCCCCAC4912D2D9DF903EF9888B8A0E4CFF


class C2tnb239v2(KoblitzInterface):
    m = 239
    coefficients = [239, 36, 0]
    a = 0x4230017757A767FAE42398569B746325D45313AF0766266479B75654E65F
    b = 0x5037EA654196CFF0CD82B2C14A2FCF2E3FF8775285B545722F03EACDB74B
    G = (
        0x28F9D04E900069C8DC47A08534FE76D2B900B7D7EF31F5709F200C4CA205,
        0x5667334C45AFF3B5A03BAD9DD75E2C71A99362567D5453F7FA6E227EC833,
    )
    n = 0x1555555555555555555555555555553C6F2885259C31E3FCDF154624522D


class C2tnb239v1(KoblitzInterface):
    m = 239
    coefficients = [239, 36, 0]
    a = 0x32010857077C5431123A46B808906756F543423E8D27877578125778AC76
    b = 0x790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16
    G = (
        0x57927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D,
        0x61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305,
    )
    n = 0x2000000000000000000000000000000F4D42FFE1492A4993F1CAD666E447


class C2pnb272w1(KoblitzInterface):
    m = 272
    coefficients = [272, 56, 3, 1, 0]
    a = 0x91A091F03B5FBA4AB2CCF49C4EDD220FB028712D42BE752B2C40094DBACDB586FB20
    b = 0x7167EFC92BB2E3CE7C8AAAFF34E12A9C557003D7C73A6FAF003F99F6CC8482E540F7
    G = (
        0x6108BABB2CEEBCF787058A056CBE0CFE622D7723A289E08A07AE13EF0D10D171DD8D,
        0x10C7695716851EEF6BA7F6872E6142FBD241B830FF5EFCACECCAB05E02005DDE9D23,
    )
    n = 0x0100FAF51354E0E39E4892DF6E319C72C8161603FA45AA7B998A167B8F1E629521


class C2pnb304w1(KoblitzInterface):
    m = 304
    coefficients = [304, 11, 2, 1, 0]
    a = 0xFD0D693149A118F651E6DCE6802085377E5F882D1B510B44160074C1288078365A0396C8E681
    b = 0xBDDB97E555A50A908E43B01C798EA5DAA6788F1EA2794EFCF57166B8C14039601E55827340BE
    G = (
        0x197B07845E9BE2D96ADB0F5F3C7F2CFFBD7A3EB8B6FEC35C7FD67F26DDF6285A644F740A2614,
        0xE19FBEB76E0DA171517ECF401B50289BF014103288527A9B416A105E80260B549FDC1B92C03B,
    )
    n = 0x0101D556572AABAC800101D556572AABAC8001022D5C91DD173F8FB561DA6899164443051D


class C2pnb368w1(KoblitzInterface):
    m = 368
    coefficients = [368, 85, 2, 1, 0]
    a = 0xE0D2EE25095206F5E2A4F9ED229F1F256E79A0E2B455970D8D0D865BD94778C576D62F0AB7519CCD2A1A906AE30D
    b = 0xFC1217D4320A90452C760A58EDCD30C8DD069B3C34453837A34ED50CB54917E1C2112D84D164F444F8F74786046A
    G = (
        0x1085E2755381DCCCE3C1557AFA10C2F0C0C2825646C5B34A394CBCFA8BC16B22E7E789E927BE216F02E1FB136A5F,
        0x7B3EB1BDDCBA62D5D8B2059B525797FC73822C59059C623A45FF3843CEE8F87CD1855ADAA81E2A0750B80FDA2310,
    )
    n = 0x010090512DA9AF72B08349D98A5DD4C7B0532ECA51CE03E2D10F3B7AC579BD87E909AE40A6F131E9CFCE5BD967


class C2tnb359v1(KoblitzInterface):
    m = 359
    coefficients = [359, 68, 0]
    a = 0x5667676A654B20754F356EA92017D946567C46675556F19556A04616B567D223A5E05656FB549016A96656A557
    b = 0x2472E2D0197C49363F1FE7F5B6DB075D52B6947D135D8CA445805D39BC345626089687742B6329E70680231988
    G = (
        0x3C258EF3047767E7EDE0F1FDAA79DAEE3841366A132E163ACED4ED2401DF9C6BDCDE98E8E707C07A2239B1B097,
        0x53D7E08529547048121E9C95F3791DD804963948F34FAE7BF44EA82365DC7868FE57E4AE2DE211305A407104BD,
    )
    n = 0x01AF286BCA1AF286BCA1AF286BCA1AF286BCA1AF286BC9FB8F6B85C556892C20A7EB964FE7719E74F490758D3B


class C2tnb431r1(KoblitzInterface):
    m = 431
    coefficients = [431, 120, 0]
    a = 0x1A827EF00DD6FC0E234CAF046C6A5D8A85395B236CC4AD2CF32A0CADBDC9DDF620B0EB9906D0957F6C6FEACD615468DF104DE296CD8F
    b = 0x10D9B4A3D9047D8B154359ABFB1B7F5485B04CEB868237DDC9DEDA982A679A5A919B626D4E50A8DD731B107A9962381FB5D807BF2618
    G = (
        0x120FC05D3C67A99DE161D2F4092622FECA701BE4F50F4758714E8A87BBF2A658EF8C21E7C5EFE965361F6C2999C0C247B0DBD70CE6B7,
        0x20D0AF8903A96F8D5FA2C255745D3C451B302C9346D9B7E485E7BCE41F6B591F3E8F6ADDCBB0BC4C2F947A7DE1A89B625D6A598B3760,
    )
    n = 0x0340340340340340340340340340340340340340340340340340340323C313FAB50589703B5EC68D3587FEC60D161CC149C1AD4A91


class Wap_wsg_idm_ecid_wtls1(KoblitzInterface):
    m = 113
    coefficients = [113, 9, 0]
    a = 1
    b = 1
    G = (0x01667979A40BA497E5D5C270780617, 0x00F44B4AF1ECC2630E08785CEBCC15)
    n = 0x00FFFFFFFFFFFFFFFDBF91AF6DEA73


class Test_Curve(KoblitzInterface):
    m = 5
    coefficients = [5, 2, 0]
    a = 13
    b = 4
    G = (22, 19)
    n = 16

    def __init__(self):
        logger.warn(
            "koblitz test-curve is for development and educational purposes only"
            " and should not be used in production."
        )
