from flask import Flask, request, jsonify
from deepface import DeepFace
import base64, uuid
from flask_cors import CORS
import os

app = Flask(__name__)
CORS(app)   # ✅ AFTER app create

def save_base64(base64_string):
    imgdata = base64.b64decode(base64_string.split(",")[1])
    filename = f"{uuid.uuid4()}.jpg"
    with open(filename, 'wb') as f:
        f.write(imgdata)
    return filename
    
@app.route("/")
def home():
    return "Face API Running"

@app.route("/match", methods=["POST"])
def match():
    try:
        img1 = request.json["img1"]
        img2 = request.json["img2"]

        f1 = save_base64(img1)
        f2 = save_base64(img2)

        result = DeepFace.verify(
            f1,
            f2,
            model_name="Facenet",        # ⭐ faster + accurate
            detector_backend="opencv",
            enforce_detection=False
        )

        os.remove(f1)
        os.remove(f2)

        return jsonify({
            "success": True,
            "match": result["verified"],
            "distance": float(result["distance"])
        })

    except Exception as e:
        return jsonify({"success": False, "error": str(e)})

app.run(host="0.0.0.0", port=5000)